/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2001 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
*
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include <math.h>
#include "ctaltdel.h"
#include "resource.h"

//IMGVERS.DLL - Version checking
#define GWV_WIN95 0x01
#define GWV_WIN98 0x02
#define GWV_WIN32S 0x0F
#define GWV_NT4WKSTN 0x11
#define GWV_NT4SERVER 0x12
#define GWV_NT4TERMSERV 0x14
#define GWV_NT4ERROR 0x18
#define GWV_W2KWKSTN 0x21
#define GWV_W2KSERVER 0x22
#define GWV_W2KTERMSERV 0x24
#define GWV_GETVERERROR 0xF0
#define GWV_NONE 0xFF

HINSTANCE hVersionLib;
typedef int (WINAPI *fpGWV)(void);
fpGWV fpGetWinVersion;

//IMGLOGON.DLL - Communicate SAS
typedef BOOL (WINAPI *fpGN)(unsigned short []);
fpGN fpGenerateNotify;

//determines which platform, how to operate - 
//Restart or Call IMGLOGON/GenerateNotify
BOOL bWinNT2000 = FALSE;

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "My-T-Soft Ctrl-Alt-Del";

char cBuf[5000];
char cModulePath[MAX_PATH];

HWND hWindow,hDialog = NULL;
HANDLE hInst;


/*************************************************************************
* Functions
*************************************************************************/
BOOL EnablePrivilege(LPTSTR);
BOOL DisablePrivilege(LPTSTR);
//  ExitWindowsEx(EWX_REBOOT,0);  //restart / reboot 
//     ExitWindowsEx(EWX_SHUTDOWN,0);  //shutdown to safe
//     ExitWindowsEx(EWX_LOGOFF,0);  //log off user
//     ExitWindowsEx(EWX_POWEROFF,0);  //power down (if supported)

/*************************************************************************
* WinMain
*************************************************************************/
int PASCAL WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
{
 HWND	hwnd; //,hWork,hTemp;
 MSG msg;
 WNDCLASSEX wndclass;
 int i;

 UNREFPARM(hPrevInstance);
 UNREFPARM(lpszCmdParam);


 wndclass.cbSize = sizeof(WNDCLASSEX);
	wndclass.style           = CS_HREDRAW | CS_VREDRAW;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(PLAYICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;
 wndclass.hIconSm         = NULL;
	
	RegisterClassEx(&wndclass);

	
 hwnd = CreateWindow(szAppName,szAppName,
						 WS_OVERLAPPEDWINDOW,
									 CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;

 i = GetModuleFileName(hInstance,(LPSTR) cModulePath,MAX_PATH);
 while (i >= 0)
 {
	 if (cModulePath[i] == '\\') break;
	 else cModulePath[i] = 0;
	 if (!i) break;
	 i--;
 }
 i = lstrlen((LPSTR) cModulePath);
 if (cModulePath[i-1] != '\\') lstrcat((LPSTR) cModulePath,"\\");
  
//check version to determine action of CTALTDEL (Ctrl-Alt-Del)
 hVersionLib = LoadLibrary("IMGVERS.DLL");
 if (!hVersionLib)
 {
  MessageBox(NULL,"Error opening IMGVERS.DLL!  Cannot continue...\nCheck Installation and retry!",szAppName,MB_OK | MB_ICONEXCLAMATION);
  return FALSE;
 }
 fpGetWinVersion = (fpGWV) GetProcAddress(hVersionLib,"GetWinVersion");
 switch ((*fpGetWinVersion)())
 {
  case GWV_WIN95:
   //MessageBox(NULL,"Windows 95",MYT_WINDOWNAME,MB_OK | MB_ICONEXCLAMATION);
   break;
  case GWV_WIN98:
   //MessageBox(NULL,"Windows 98",MYT_WINDOWNAME,MB_OK | MB_ICONEXCLAMATION);
   break;
  case GWV_WIN32S:
   //MessageBox(NULL,"Improper Windows Version!",MYT_WINDOWNAME,MB_OK | MB_ICONEXCLAMATION);
   break;
  case GWV_NT4WKSTN:
   //MessageBox(NULL,"Windows NT 4 Workstation",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;
  case GWV_NT4SERVER:
   //MessageBox(NULL,"Windows NT 4 Server",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;
  case GWV_NT4TERMSERV:
   //MessageBox(NULL,"Windows NT 4 Terminal Server",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;
  case GWV_NT4ERROR:
   //windows NT / Other
   break;
  case GWV_W2KWKSTN:
   //MessageBox(NULL,"Windows 2000 Workstation",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;
  case GWV_W2KSERVER:
   //MessageBox(NULL,"Windows 2000 Server",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;
  case GWV_W2KTERMSERV:
   //MessageBox(NULL,"Windows 2000 Terminal Server",MYT_WINDOWNAME,MB_OK);
   bWinNT2000 = TRUE;
   break;

  case GWV_GETVERERROR:
   MessageBox(NULL,"Windows System Error - GetVersionEx has failed! Cannot continue...",szAppName,MB_OK | MB_ICONEXCLAMATION);
   return FALSE;
  case GWV_NONE:
   MessageBox(NULL,"Improper Windows Version!",szAppName,MB_OK | MB_ICONEXCLAMATION);
   return FALSE;

 }  //version lib exists
 FreeLibrary(hVersionLib);


 SetTimer(hwnd,1,50,NULL);

 //ShowWindow(hwnd,nCmdShow);
 //UpdateWindow(hwnd);
 ShowWindow(hwnd,SW_HIDE);
 

 while (GetMessage(&msg,NULL,0,0))
 {
 	TranslateMessage(&msg);
	 DispatchMessage(&msg);
 }


 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
LRESULT WINAPI WndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
 PAINTSTRUCT ps;
 HDC hDC;//,hDCmem;
 unsigned short lpWide[50];
 HANDLE hLib;
 BOOL bResult;

switch (message)
{
 case WM_COMMAND:
  break;
	
  case WM_TIMER:
   KillTimer(hwnd,1);
   if (bWinNT2000)
   {

    //IMGLOGON.DLL is unicode
    MultiByteToWideChar(CP_ACP,MB_PRECOMPOSED,"IMG Logon",-1,lpWide,50);

    hLib = LoadLibrary("IMGLOGON.DLL");
    if (hLib)
    {
     fpGenerateNotify = (fpGN) GetProcAddress(hLib,"GenerateNotify");
     if (fpGenerateNotify)
     {
      bResult = (*fpGenerateNotify)(lpWide);
      //TRUE is success, FALSE failure
     }
     else MessageBox(NULL,"Error: COULD NOT GETPROCADDRESS GenerateNotify",szAppName,MB_OK);
     FreeLibrary(hLib);
    }
    else MessageBox(NULL,"Error: COULD NOT LOAD IMGLOGON.DLL",szAppName,MB_OK);
   }
   else
   {
    //95/98/Me
    EnablePrivilege(SE_SHUTDOWN_NAME);
    ExitWindowsEx(EWX_REBOOT,0);
    DisablePrivilege(SE_SHUTDOWN_NAME);
    PostMessage(hwnd,WM_CLOSE,0,0);
   }

   return 0;

	case WM_PAINT:
	 hDC = BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* EnablePrivilege
*************************************************************************/
BOOL EnablePrivilege(LPTSTR privilege)
{
	BOOL success;
	HANDLE token;
	LUID luid;
	TOKEN_PRIVILEGES tokenPrivileges;

	// Get token for this process
	success = OpenProcessToken(GetCurrentProcess(),
		TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
		&token);
	if (!success) return FALSE;

	// Gets the value for a privilege
	success = LookupPrivilegeValue(0, privilege,&luid);
	if (!success) return FALSE;

	// Enable the privilege
	tokenPrivileges.PrivilegeCount = 1;
	tokenPrivileges.Privileges[0].Luid = luid;
	tokenPrivileges.Privileges[0].Attributes =
		SE_PRIVILEGE_ENABLED;
	AdjustTokenPrivileges(token, FALSE,
		&tokenPrivileges, 0, 0, 0);
	// Always returns true, so check GetLastError
	if (GetLastError() != ERROR_SUCCESS)
	{
		return FALSE;
	}
	return TRUE;
}
/*************************************************************************
* DisablePrivilege
*************************************************************************/
BOOL DisablePrivilege(LPTSTR privilege)
{
	BOOL success;
	HANDLE token;
	LUID luid;
	TOKEN_PRIVILEGES tokenPrivileges;

	// Get tokens for this process
	success = OpenProcessToken(GetCurrentProcess(), 
		TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY,
		&token);
	if (!success) return FALSE;

	// Gets the value for a privilege
	success = LookupPrivilegeValue(0, privilege,
		&luid);
	if (!success)	return FALSE;

	// Disable the privilege
	tokenPrivileges.PrivilegeCount = 1;
	tokenPrivileges.Privileges[0].Luid = luid;
	// disable the privilege
	tokenPrivileges.Privileges[0].Attributes = 0;
	AdjustTokenPrivileges(token, FALSE,
		&tokenPrivileges, 0, 0, 0);
	// Always returns true, so...
	if (GetLastError() != ERROR_SUCCESS)
	{
		return FALSE;
	}
	return TRUE;
}/*************************************************************************
* END OF CODE
*************************************************************************/
