/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2001 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include "mytsoft.h"

/*************************************************************************
* defines
*************************************************************************/

#define WINPRODKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "Configure My-T-Soft";
char szCmd[200];
char szDefINI[200] = "C:\\WINNT\\MYTSOFT\\MYTSOFT.INI";
char szMTSINI[200];

HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch);
LPSTR lstrrchr(LPSTR str,char ch);
void ParseCmdUpdateIni(void);
HWND FindMyTSoft(void);
void UpdateDefINI(HWND);

/*************************************************************************
* WinMain
*************************************************************************/
#ifdef MYTWIN32
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#else
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#endif
{
 HWND	hwnd;
 MSG msg;
 WNDCLASS wndclass;
 int x,y,w,h;

 lstrcpy((LPSTR) szCmd,lpszCmdParam);
 UNREFPARM(nCmdShow);

 //Use szMTSINI path for location of file
 //default entry unless CONFGMTS.INI exists - see Text
 UpdateDefINI(FindMyTSoft());
#ifdef MYTWIN32
 //1.71
 //do not allow override - software location set in registry at install
 //For non-standard installs, developer can modify or hard code the INI
 //file location
  lstrcpy(szMTSINI,szDefINI);
#else
 GetPrivateProfileString((LPSTR) "Location",(LPSTR) "MTSINIFILE",
  (LPSTR) szDefINI,
  (LPSTR) szMTSINI,200,
  (LPSTR) "CONFGMTS.INI");
#endif
 if (!hPrevInstance)
 {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(THEICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;

	RegisterClass(&wndclass);
 }
 //OrgW = w = GetSystemMetrics(SM_CXSCREEN);
 //OrgH = h = GetSystemMetrics(SM_CYSCREEN);
 //x = (GetSystemMetrics(SM_CXSCREEN) /2) - (w/2);
 //y = (GetSystemMetrics(SM_CYSCREEN) /2) - (h/2);

 //MaxX = w - 100;
 //MaxY = h - 100;
 //MinX = MaxX / 10;
 //MinY = MaxY / 10;
 //OffsetX = MaxX / 2;
 //OffsetY = MaxY / 2;

 //OrgX = x;OrgY = y;
 w = h = 0;
 x = GetSystemMetrics(SM_CXSCREEN) + 1;
 y = GetSystemMetrics(SM_CYSCREEN) + 1;

 hwnd = CreateWindow(szAppName,szAppName,
//						 WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
						 WS_DISABLED | WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
									 x,y,w,h,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;


 //ShowWindow(hwnd,nCmdShow);
 ShowWindow(hwnd,SW_HIDE);
 UpdateWindow(hwnd);

 PostMessage(hwnd,WM_COMMAND,TRUE,0);

 while (GetMessage(&msg,NULL,0,0))
 {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
 }


 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
#ifdef MYTWIN32
LRESULT WINAPI WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 PAINTSTRUCT ps;
 HWND hWork;
 UINT wMessage1;

#else  //MYTWIN32
long FAR PASCAL WndProc(HWND hwnd,WORD message,WORD wParam,LONG lParam)
{
 char cWork[3];
 MSG msg;
 LONG lSelect,lWork;
 PAINTSTRUCT ps;
 OFSTRUCT of;
 WORD wEnable,wLine,wString,wMessage1;
 HWND hTemp,hWork;
 LPSTR lpClassName;
 HBITMAP hBitmap,hOldbit;
 HFONT hOldfont;
 HPEN hPen,hOldpen;
 HBRUSH hBrush,hOldbrush;
 POINT pPoint;
 RECT rect;
 HDC hDC,hDCmem;
 HANDLE hResource,hData;
 LPSTR lpData;
 int i,j,k;
 int x,y,z;
#endif

 switch (message)
 {
	case WM_SIZE:
	 break;

	case WM_PAINT:
	 BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;
	case WM_LBUTTONDOWN:
	 break;
  case WM_LBUTTONDBLCLK:
	 break;
	case WM_RBUTTONDOWN:
	 break;
  case WM_RBUTTONDBLCLK:
	 break;
	case WM_MBUTTONDOWN:
	 break;
	case WM_COMMAND:
   if (wParam)
   {
    hWork = FindMyTSoft();
    if (hWork)
    {
		 wMessage1 = RegisterWindowMessage(MYT_MSG1);
     ShowWindow(hWork,SW_HIDE);

     ParseCmdUpdateIni();

		 SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_UPDATE,0));
     ShowWindow(hWork,SW_SHOW);


     PostMessage(hwnd,WM_CLOSE,0,0);
    }
    else
    {
     //no My-T-Soft found!
     ParseCmdUpdateIni();
     PostMessage(hwnd,WM_CLOSE,0,0);
    }
    return 0;
   }
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* ParseCmdUpdateIni
*************************************************************************/
void ParseCmdUpdateIni(void)
{
 LPSTR lps;
 int i;
 char cWork[200];

 AnsiUpperBuff(szCmd,200);

 lps = (LPSTR) szCmd;
 while (lps)
 {
  lps = lstrchr((LPSTR) lps,'/');
  if (!lps) break;
  lps++;  //to letter
  switch (*lps)
  {
   case 'K':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'E':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'N':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'C':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'M':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'W':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'T':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'S':
    lps++;
    if (*lps == ':')
    {
     lps++;
     i = 0;
     cWork[i] = *lps;
     if (cWork[i] == '1')
     {
      lps++;
      i++;
      cWork[i] = *lps;
     }
     cWork[i+1] = 0;
     WritePrivateProfileString((LPSTR) "Configuration",(LPSTR) "Size",
       (LPSTR) cWork,(LPSTR) szMTSINI);
    }
    break;
  }//switch
 }  //while
}
/*************************************************************************
* lstrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = AnsiNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrrchr(LPSTR str,char ch)
{
 LPSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = AnsiPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Touch");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Pen");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "TouchType");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "FastPoint");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "EasyKey");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "JobPack");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "OnScreen");
 return hTemp;
}
/*************************************************************************
* UpdateDefINI ties specific default INI files to
*************************************************************************/
void UpdateDefINI(HWND hWnd)
{
 TCHAR cWork[250];
 TCHAR szRegKey[500];
 HKEY keyH;
 DWORD dwValue;
 DWORD dwSize;
 LPSTR lps;
 int i;

 if (hWnd)
 {
  if (GetWindowText(hWnd,(LPSTR) cWork,29))
  {
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Soft"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTSOFT\\MYTSOFT.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTSOFT.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Touch"))
   {
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTTOUCH\\MYTTOUCH.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTTOUCH.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Pen"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTPEN\\MYTPEN.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
  }  //GetWindowText has a string
 }
 else  //hWnd is NULL
 {
  szDefINI[0] = 0; // null INI string

  //Try all 3 products, start with My-T-Soft
  lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
  lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Soft");

  dwValue = REG_SZ;
  dwSize = sizeof(cWork);

  cWork[0] = 0;
  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
  {  
   if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
   {
    //See if value, then rework szDefINI
    if (lstrlen(cWork) > 0)
    {
     lps = lstrrchr(cWork,'\\');
     if (lps)
     {
      lps++;
      *lps = 0;
      lstrcat(cWork,"MYTSOFT.INI");
      lstrcpy(szDefINI,cWork);
     }
    }
   }
   RegCloseKey(keyH);
  }
  else //fail on My-T-Soft
  {
   lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
   lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Touch");

   dwValue = REG_SZ;
   dwSize = sizeof(cWork);

   cWork[0] = 0;
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
   {  
    if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
    {
     //See if value, then rework szDefINI
     if (lstrlen(cWork) > 0)
     {
      lps = lstrrchr(cWork,'\\');
      if (lps)
      {
       lps++;
       *lps = 0;
       lstrcat(cWork,"MYTTOUCH.INI");
       lstrcpy(szDefINI,cWork);
      }
     }
    }
    RegCloseKey(keyH);
   }
   else  //fail on My-T-Touch
   {
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Pen");

    dwValue = REG_SZ;
    dwSize = sizeof(cWork);

    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    } //fail on My-T-Pen
   } //fail on My-T-Touch
  } //fail on My-T-Soft
 } //hWnd 
}
/*************************************************************************
* END OF CODE
*************************************************************************/
