/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2002 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include "mytsoft.h"

/*************************************************************************
* defines
*************************************************************************/

#define WINPRODKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"

//PROJECT SETTINGS require /Zp1 to allow for single byte packing (to match
//KBF file reading/writing!!!!!!!)

//additional structures to accommodate file read & write
typedef struct tagSRECT
{
 short left;
 short top;
 short right;
 short bottom;
} SRECT;

typedef struct     // My-T-Mouse structure - 89 bytes
{
 char  astrix[1];
 char  MyTMouse[4];
 char  Name[30];
 short KeyBoards;
 short Keys;
 short nKeyBoard;
	DWORD dwBackBrush;
	DWORD dwCurrentMacroPanel;
	short bSlideOption;
	short bTime;
	short bDate;
	short bCurPos;
	short bFreeDsk;
	short bFreeMem;
	short bFreeRes;
 SRECT MyTKeyboard;
 SRECT MyTPosition;
	short MyTSize;
	SRECT MyTMouseSize;
} MyTMConfiguration16;

typedef MyTMConfiguration16 NEAR *NPMYTMCONFIG;


/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "My-T-Soft to Icon";
char szCmd[200];
char szDefINI[200] = "C:\\WINNT\\MYTSOFT\\MYTSOFT.INI";
char szMTSINI[200];


HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

//MTTStart Variables
int iWhich = 0;
int iTime = 750;
RECT rcOrg;

BOOL bLaunched = FALSE;
BOOL bModifiedKBF = FALSE;

/*************************************************************************
* Functions
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch);
LPSTR lstrrchr(LPSTR str,char ch);
void UpdateDefINI(HWND);
HWND FindMyTSoft(void);

BOOL ModifyKBF(LPSTR szFileNameKBF,int x,int y);

/*************************************************************************
* WinMain
*************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
{
 HWND	hwnd;
 MSG msg;
 WNDCLASS wndclass;
 int x,y,w,h;
 char cBuf[100];
 UNREFPARM(nCmdShow);

 //UNREFPARM(lpszCmdParam);
 if (lstrlen(lpszCmdParam) > 0)
 {
  lstrcpy(cBuf,lpszCmdParam);
  iTime = atoi(cBuf);
  itoa(iTime,cBuf,10);
  if ((iTime < 250) || (iTime > 10000)) iTime = 750;
 }

 //Use szMTSINI path for location of file
 //default entry unless CONFGMTS.INI exists - see Text
 UpdateDefINI(FindMyTSoft());
 //1.71
 //do not allow override - software location set in registry at install
 //For non-standard installs, developer can modify or hard code the INI
 //file location
 lstrcpy(szMTSINI,szDefINI);

 if (!hPrevInstance)
 {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(THEICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;

	RegisterClass(&wndclass);
 }
 //OrgW = w = GetSystemMetrics(SM_CXSCREEN);
 //OrgH = h = GetSystemMetrics(SM_CYSCREEN);
 //x = (GetSystemMetrics(SM_CXSCREEN) /2) - (w/2);
 //y = (GetSystemMetrics(SM_CYSCREEN) /2) - (h/2);

 //MaxX = w - 100;
 //MaxY = h - 100;
 //MinX = MaxX / 10;
 //MinY = MaxY / 10;
 //OffsetX = MaxX / 2;
 //OffsetY = MaxY / 2;

 //OrgX = x;OrgY = y;
 w = h = 0;
 x = GetSystemMetrics(SM_CXSCREEN) + 1;
 y = GetSystemMetrics(SM_CYSCREEN) + 1;

 hwnd = CreateWindow(szAppName,szAppName,
//						 WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
						 WS_DISABLED | WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
									 x,y,w,h,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;

 SetTimer(hwnd,1,iTime,NULL);

 //ShowWindow(hwnd,nCmdShow);
 ShowWindow(hwnd,SW_HIDE);
 UpdateWindow(hwnd);

 while (GetMessage(&msg,NULL,0,0))
 {
 	TranslateMessage(&msg);
 	DispatchMessage(&msg);
 }

 KillTimer(hwnd,1);

 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
LRESULT WINAPI WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 PAINTSTRUCT ps;
 HWND hWork;
 UINT wMessage1;
 int i;

 switch (message)
 {
	case WM_SIZE:
	 break;
  case WM_TIMER:
   //use timer click to trigger
   //MTSISTRT Modified from MTSSTART to do some different tricks
   //Using a timer, each successive step is executed
   //Used in startup to manage opening of MTS
   //If not already running:
   //Modify KBF to open off screen, run with -nosplash
   //once open, minimize
   //modify KBF again to open where desired

   hWork = FindMyTSoft();
   if (hWork)
   {

    wMessage1 = RegisterWindowMessage(MYT_MSG1);
    iWhich++;
    
    if (iWhich == 1)
    {
     //Must be Active, or just stay in holding pattern...
     if (SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_ISACTIVE))
     {
      return 0;
     }
     //reset to 0, continue to wait until active
     iWhich = 0;
     return 0;
    } // 1
    if (iWhich == 2)
    {
     //should not be minimized, but if it is, open & reset
     i = FALSE;
     if (SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_ISBUTTON)) i = 1;
     if (SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_ISICONIC)) i = 1;
     if (i)
     {
      SendMessage(hWork,wMessage1,MYTMSG_OPEN,0L);
      iWhich = 0;
      return 0;
     }

     return 0;
    } //2
    if (iWhich == 3)
    {
     TCHAR szKBF[MAX_PATH];
     LPSTR lps;

     if (bModifiedKBF) //protect if MTS already running
     {
      bModifiedKBF = FALSE;
      //modify KBF back to org
      lstrcpy(szKBF,szMTSINI);
      lps = lstrrchr(szKBF,'\\');
      if (lps)
      {
       lps++;
       *lps = 0; //end after slash
       lstrcat(szKBF,"KEYBOARD.KBF");
       ModifyKBF(szKBF,-(GetSystemMetrics(SM_CXSCREEN)+1),0);
       //ModifyKBF(szKBF,-(300),-100);
      }
     }

     SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_GOTOICON);

     return 0;
    } //iWhich == 3 
    if (iWhich == 4)
    {
     i = FALSE;
     if (SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_ISBUTTON)) i = 1;
     if (SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MYTMSGREQ_ISICONIC)) i = 1;
     if (!i)
     { 
      HWND hIcon;
      hIcon = FindWindow("MyTIcon",NULL);
      if (IsWindowVisible(hIcon)) i = 1;
     }
     if (i)
     {
      //while in an iconic mode, keep process running in a holding pattern...
      iWhich = 3;
      return 0;
     }
    }  //4
    if (iWhich == 5)
    {
     //finally, restore MTS to correct position and close process
	  	 SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
     PostMessage(hwnd,WM_CLOSE,0,0);
     return 0;
    } //iWhich == 5



   }
   else
   {
    //no My-T-Soft found!
    //Modify KBF, then Run with -Nosplash
    if (!bLaunched)
    {
     TCHAR szLaunch[MAX_PATH];
     TCHAR szKBF[MAX_PATH];
     LPSTR lpp,lps;
    
     bLaunched = TRUE;
     //modify KBF
     lstrcpy(szKBF,szMTSINI);
     lps = lstrrchr(szKBF,'\\');
     if (lps)
     {
      lps++;
      *lps = 0; //end after slash
      lstrcat(szKBF,"KEYBOARD.KBF");
      ModifyKBF(szKBF,GetSystemMetrics(SM_CXSCREEN)+1,0);
      //ModifyKBF(szKBF,300,100);
      bModifiedKBF = TRUE;
     }
     //if you would like to force the Shell Icon (Icon on taskbar)
     //Set MinimizetoButton=2

     //WritePrivateProfileString("Configuration","MinimizeToButton","2",szMTSINI);
     //(included in compile for MTSISTR2.EXE)

     //launch
     lstrcpy(szLaunch,szMTSINI);
     lpp = lstrrchr(szLaunch,'.');
     if (lpp)
     {
      lpp++;
      *lpp = 0; //end after period
      lstrcat(szLaunch,"EXE -NoSplash");
      WinExec(szLaunch,SW_SHOW);
     }

    } //!bLaunched

    //if No MTS, and we have incremented iWhich, MTS must be closed, kill process
    if (iWhich) PostMessage(hwnd,WM_CLOSE,0,0);

   }
   return 0;

	case WM_PAINT:
	 BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;
	case WM_LBUTTONDOWN:
	 break;
  case WM_LBUTTONDBLCLK:
	 break;
	case WM_RBUTTONDOWN:
	 break;
  case WM_RBUTTONDBLCLK:
	 break;
	case WM_MBUTTONDOWN:
	 break;
	case WM_COMMAND:
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Touch");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Pen");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse for Kids");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "TouchType");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "FastPoint");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "EasyKey");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "JobPack");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "OnScreen");
 return hTemp;
}
/*************************************************************************
* lstrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = AnsiNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrrchr(LPSTR str,char ch)
{
 LPSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = AnsiPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* UpdateDefINI ties specific default INI files to
*************************************************************************/
void UpdateDefINI(HWND hWnd)
{
 TCHAR cWork[250];
 TCHAR szRegKey[500];
 HKEY keyH;
 DWORD dwValue;
 DWORD dwSize;
 LPSTR lps;
 int i;

 if (hWnd)
 {
  if (GetWindowText(hWnd,(LPSTR) cWork,29))
  {
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Soft"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTSOFT\\MYTSOFT.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTSOFT.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Touch"))
   {
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTTOUCH\\MYTTOUCH.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTTOUCH.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Pen"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTPEN\\MYTPEN.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
  }  //GetWindowText has a string
 }
 else  //hWnd is NULL
 {
  szDefINI[0] = 0; // null INI string

  //Try all 3 products, start with My-T-Soft
  lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
  lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Soft");

  dwValue = REG_SZ;
  dwSize = sizeof(cWork);

  cWork[0] = 0;
  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
  {  
   if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
   {
    //See if value, then rework szDefINI
    if (lstrlen(cWork) > 0)
    {
     lps = lstrrchr(cWork,'\\');
     if (lps)
     {
      lps++;
      *lps = 0;
      lstrcat(cWork,"MYTSOFT.INI");
      lstrcpy(szDefINI,cWork);
     }
    }
   }
   RegCloseKey(keyH);
  }
  else //fail on My-T-Soft
  {
   lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
   lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Touch");

   dwValue = REG_SZ;
   dwSize = sizeof(cWork);

   cWork[0] = 0;
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
   {  
    if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
    {
     //See if value, then rework szDefINI
     if (lstrlen(cWork) > 0)
     {
      lps = lstrrchr(cWork,'\\');
      if (lps)
      {
       lps++;
       *lps = 0;
       lstrcat(cWork,"MYTTOUCH.INI");
       lstrcpy(szDefINI,cWork);
      }
     }
    }
    RegCloseKey(keyH);
   }
   else  //fail on My-T-Touch
   {
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Pen");

    dwValue = REG_SZ;
    dwSize = sizeof(cWork);

    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    } //fail on My-T-Pen
   } //fail on My-T-Touch
  } //fail on My-T-Soft
 } //hWnd 
}
/*************************************************************************
* Modify KBF
*************************************************************************/
BOOL ModifyKBF(LPSTR szFileNameKBF,int x,int y)
{
 HANDLE hF;
 DWORD dwNumRead;
 NPMYTMCONFIG  npMyTMConfig = NULL;
 LOCALHANDLE   hMyTMConfig = NULL;
 TCHAR cBuf[100];
 BOOL bResult;
 SRECT rtmp;

 hF = CreateFile((LPSTR) szFileNameKBF,GENERIC_READ | GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE,0,
          OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0);
 if (hF == INVALID_HANDLE_VALUE)
 {
  MessageBox(NULL,"Pre 2.00 KBF file, File Open Fail (82)","My-T-Soft Utility Error",MB_OK | MB_ICONINFORMATION);
  return 0;
 }
	// Read the Header record from the keyboard file
 if (!hMyTMConfig) hMyTMConfig = LocalAlloc (LMEM_MOVEABLE | LMEM_ZEROINIT,sizeof(MyTMConfiguration16));
	npMyTMConfig = (NPMYTMCONFIG) LocalLock(hMyTMConfig);
	if (!npMyTMConfig) MessageBox(NULL,"Pre 2.00 KBF file, Config Memory fail (50)","My-T-Soft Utility Error",MB_OK | MB_ICONINFORMATION);
 if (!ReadFile(hF,npMyTMConfig,sizeof(MyTMConfiguration16),&dwNumRead,NULL))
 {
  LocalUnlock(hMyTMConfig);
  CloseHandle(hF);
  MessageBox(NULL,"Pre 2.00 KBF file, File Read Fail (83)","My-T-Soft Utility Error",MB_OK | MB_ICONINFORMATION);
  return 0;
 }
 bResult = TRUE;

	// Check for valid file type and hold for identification
 lstrcpyn((LPSTR) cBuf,npMyTMConfig->MyTMouse,5);
 if ( (lstrcmp(cBuf, "MyTM")) || (*npMyTMConfig->astrix != (char) '*') )
 {
 	LocalUnlock(hMyTMConfig);
  CloseHandle(hF);
  MessageBox(NULL,"Pre 2.00 KBF file, Invalid Signature (84)","My-T-Soft Utility Error",MB_OK | MB_ICONINFORMATION);
  return 0;
 }
 //Modify values, then write new config
 //do extra coding to allow for different ways of modifying position rectangle

 rtmp.top = npMyTMConfig->MyTPosition.top;
 rtmp.left = npMyTMConfig->MyTPosition.left;
 rtmp.bottom = npMyTMConfig->MyTPosition.bottom;
 rtmp.right = npMyTMConfig->MyTPosition.right;
 
 rtmp.left += x;
 rtmp.right += x;
 rtmp.top += y;
 rtmp.bottom += y;

 npMyTMConfig->MyTPosition.top = rtmp.top;
 npMyTMConfig->MyTPosition.left = rtmp.left;
 npMyTMConfig->MyTPosition.bottom = rtmp.bottom;
 npMyTMConfig->MyTPosition.right = rtmp.right;

 //reset file, write new data
 SetFilePointer(hF,0,0,FILE_BEGIN);
 if (!WriteFile(hF,npMyTMConfig,sizeof(MyTMConfiguration16),&dwNumRead,NULL))
 {
  LocalUnlock(hMyTMConfig);
  CloseHandle(hF);
  MessageBox(NULL,"File Write Fail (84)","My-T-Soft Utility Error",MB_OK | MB_ICONINFORMATION);
  return 0;
 }

 LocalUnlock(hMyTMConfig);
	CloseHandle(hF);
 return bResult;
}
/*************************************************************************
* END OF CODE
*************************************************************************/
