/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2002 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <dos.h>
#include <io.h>
#include <sys\stat.h>
#include "mytsoft.h"

/*************************************************************************
* defines
*************************************************************************/

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "Configure My-T-Soft";
char szCmd[200];

BYTE WorkBuff[20000];

HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch);
LPSTR lstrrchr(LPSTR str,char ch);
HWND FindMyTSoft(void);
void UpdateDefINI(HWND);

/*************************************************************************
* WinMain
*************************************************************************/
#ifdef MYTWIN32
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#else
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#endif
{
 HWND	hwnd;
 MSG msg;
 WNDCLASS wndclass;
 int x,y,w,h;


 lstrcpy((LPSTR) szCmd,lpszCmdParam);
 UNREFPARM(nCmdShow);


 if (!hPrevInstance)
 {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(THEICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;

	RegisterClass(&wndclass);
 }
 //OrgW = w = GetSystemMetrics(SM_CXSCREEN);
 //OrgH = h = GetSystemMetrics(SM_CYSCREEN);
 //x = (GetSystemMetrics(SM_CXSCREEN) /2) - (w/2);
 //y = (GetSystemMetrics(SM_CYSCREEN) /2) - (h/2);

 //MaxX = w - 100;
 //MaxY = h - 100;
 //MinX = MaxX / 10;
 //MinY = MaxY / 10;
 //OffsetX = MaxX / 2;
 //OffsetY = MaxY / 2;

 //OrgX = x;OrgY = y;
 w = h = 0;
 x = GetSystemMetrics(SM_CXSCREEN) + 1;
 y = GetSystemMetrics(SM_CYSCREEN) + 1;

 hwnd = CreateWindow(szAppName,szAppName,
//						 WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
						 WS_DISABLED | WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
									 x,y,w,h,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;

 //ShowWindow(hwnd,nCmdShow);
 ShowWindow(hwnd,SW_HIDE);
 UpdateWindow(hwnd);

 PostMessage(hwnd,WM_COMMAND,TRUE,0);

 while (GetMessage(&msg,NULL,0,0))
 {
 	TranslateMessage(&msg);
	 DispatchMessage(&msg);
 }


 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
LRESULT WINAPI WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 PAINTSTRUCT ps;
 HWND hWork;
 UINT wMessage1;
 RECT rect;


 switch (message)
 {
	case WM_SIZE:
	 break;

	case WM_PAINT:
	 BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;
	case WM_LBUTTONDOWN:
	 break;
  case WM_LBUTTONDBLCLK:
	 break;
	case WM_RBUTTONDOWN:
	 break;
  case WM_RBUTTONDBLCLK:
	 break;
	case WM_MBUTTONDOWN:
	 break;
	case WM_COMMAND:
   if (wParam)
   {
    hWork = FindMyTSoft();
    if (hWork)
    {
     //find out if window is already displayed on visible part of screen
     //1 monitor assumed
     //if window is visible, move off screen & leav

     //protect if minimized
		   if (!IsWindowEnabled(hWork))
     {
      PostMessage(hwnd,WM_CLOSE,0,0);
      return FALSE;
     }

     GetWindowRect(hWork,&rect);
     if (rect.left < GetSystemMetrics(SM_CXSCREEN))
     {
      MoveWindow(hWork,GetSystemMetrics(SM_CXSCREEN),0,rect.right-rect.left,rect.bottom-rect.top,TRUE);
      PostMessage(hwnd,WM_CLOSE,0,0);
      return FALSE;
     }
     //restore from current KBF
   		wMessage1 = RegisterWindowMessage(MYT_MSG1);
   		SendMessage(hWork,wMessage1,MYTMSG_MTSCMD_NKBF,0);

     PostMessage(hwnd,WM_CLOSE,0,0);
    }
    else
    {
     //no My-T-Soft found!
     PostMessage(hwnd,WM_CLOSE,0,0);
    }
    return 0;
   }
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* lstrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = AnsiNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrrchr(LPSTR str,char ch)
{
 LPSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = AnsiPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 return hTemp;
}
/*************************************************************************
* END OF CODE
*************************************************************************/
