/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2002 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include "mytsoft.h"

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "Restore Position My-T-Soft";


HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
HWND FindMyTSoft(void);

/*************************************************************************
* WinMain
*************************************************************************/
#ifdef MYTWIN32
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#else
int PASCAL WinMain(HANDLE hInstance,HANDLE hPrevInstance,LPSTR lpszCmdParam,int nCmdShow)
#endif
{
 HWND	hwnd;
 MSG msg;
 WNDCLASS wndclass;
 int x,y,w,h;

 UNREFPARM(lpszCmdParam);
 UNREFPARM(nCmdShow);

 if (!hPrevInstance)
 {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(THEICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;

	RegisterClass(&wndclass);
 }
 //OrgW = w = GetSystemMetrics(SM_CXSCREEN);
 //OrgH = h = GetSystemMetrics(SM_CYSCREEN);
 //x = (GetSystemMetrics(SM_CXSCREEN) /2) - (w/2);
 //y = (GetSystemMetrics(SM_CYSCREEN) /2) - (h/2);

 //MaxX = w - 100;
 //MaxY = h - 100;
 //MinX = MaxX / 10;
 //MinY = MaxY / 10;
 //OffsetX = MaxX / 2;
 //OffsetY = MaxY / 2;

 //OrgX = x;OrgY = y;
 w = h = 0;
 x = GetSystemMetrics(SM_CXSCREEN) + 1;
 y = GetSystemMetrics(SM_CYSCREEN) + 1;

 hwnd = CreateWindow(szAppName,szAppName,
//						 WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
						 WS_DISABLED | WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
									 x,y,w,h,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;


 SetTimer(hwnd,1,50,NULL);

 //ShowWindow(hwnd,nCmdShow);
 ShowWindow(hwnd,SW_HIDE);
 UpdateWindow(hwnd);

 while (GetMessage(&msg,NULL,0,0))
 {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
 }

 KillTimer(hwnd,1);

 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
#ifdef MYTWIN32
LRESULT WINAPI WndProc(HWND hwnd,UINT message,UINT wParam,LONG lParam)
{
 PAINTSTRUCT ps;
 HWND hWork;
 UINT wMessage1;

#else  //MYTWIN32
long FAR PASCAL WndProc(HWND hwnd,WORD message,WORD wParam,LONG lParam)
{
 char cWork[3];
 MSG msg;
 LONG lSelect,lWork;
 PAINTSTRUCT ps;
 OFSTRUCT of;
 WORD wEnable,wLine,wString,wMessage1;
 HWND hTemp,hWork;
 LPSTR lpClassName;
 HBITMAP hBitmap,hOldbit;
 HFONT hOldfont;
 HPEN hPen,hOldpen;
 HBRUSH hBrush,hOldbrush;
 POINT pPoint;
 RECT rect;
 HDC hDC,hDCmem;
 HANDLE hResource,hData;
 LPSTR lpData;
 int i,j,k;
 int x,y,z;

#endif

 switch (message)
 {
	case WM_SIZE:
	 break;
  case WM_TIMER:
   //use timer click to trigger close
   hWork = FindMyTSoft();
   if (hWork)
   {
  		wMessage1 = RegisterWindowMessage(MYT_MSG1);
  		SendMessage(hWork,wMessage1,MYTMSG_MTSCMD_NKBF,0);
   }
   else
   {
    //no My-T-Soft found!
    MessageBeep(MB_ICONEXCLAMATION);
   }
   PostMessage(hwnd,WM_CLOSE,0,0);
   return 0;

	case WM_PAINT:
	 BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;
	case WM_LBUTTONDOWN:
	 break;
  case WM_LBUTTONDBLCLK:
	 break;
	case WM_RBUTTONDOWN:
	 break;
  case WM_RBUTTONDBLCLK:
	 break;
	case WM_MBUTTONDOWN:
	 break;
	case WM_COMMAND:
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Touch");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Pen");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse for Kids");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "TouchType");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "FastPoint");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "EasyKey");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "JobPack");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "OnScreen");
 return hTemp;
}
/*************************************************************************
* END OF CODE
*************************************************************************/
