/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2001 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include "mytsoft.h"

/*************************************************************************
* Variables
*************************************************************************/

TCHAR szAppName[30] = TEXT("MoveWindow for My-T-Soft");
TCHAR szCmd[200];  //location for Window command line

HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
LPTSTR lstrchr(LPTSTR str,TCHAR ch);
LPTSTR lstrrchr(LPTSTR str,TCHAR ch);
HWND FindMyTSoft(void);

/*************************************************************************
* WinMain
*************************************************************************/
int WINAPI WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance,LPTSTR lpszCmdParam,int nCmdShow)
{
 HWND	hwnd;
 MSG msg;
 WNDCLASS wndclass;
 int x,y,w,h;

 lstrcpy((LPTSTR) szCmd,(LPTSTR) lpszCmdParam);
 UNREFPARM(nCmdShow);

 if (!hPrevInstance)
 {
	wndclass.style           = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
	wndclass.lpfnWndProc     = (WNDPROC) WndProc;
	wndclass.cbClsExtra      = 0;
	wndclass.cbWndExtra      = 0;
	wndclass.hInstance       = hInstance;
	wndclass.hIcon           = LoadIcon(hInstance,MAKEINTRESOURCE(THEICON));
	wndclass.hCursor         = LoadCursor(NULL,IDC_ARROW);
	wndclass.hbrBackground   = (HBRUSH) GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName    = NULL;
	wndclass.lpszClassName   = szAppName;

	RegisterClass(&wndclass);
 }
 //OrgW = w = GetSystemMetrics(SM_CXSCREEN);
 //OrgH = h = GetSystemMetrics(SM_CYSCREEN);
 //x = (GetSystemMetrics(SM_CXSCREEN) /2) - (w/2);
 //y = (GetSystemMetrics(SM_CYSCREEN) /2) - (h/2);

 //MaxX = w - 100;
 //MaxY = h - 100;
 //MinX = MaxX / 10;
 //MinY = MaxY / 10;
 //OffsetX = MaxX / 2;
 //OffsetY = MaxY / 2;

 //OrgX = x;OrgY = y;
 w = h = 0;
 x = GetSystemMetrics(SM_CXSCREEN) + 1;
 y = GetSystemMetrics(SM_CYSCREEN) + 1;

 hwnd = CreateWindow(szAppName,szAppName,
//						 WS_THICKFRAME | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
						 WS_DISABLED | WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
									 x,y,w,h,
									 NULL,NULL,hInstance,NULL);
 hInst = hInstance;

 hWindow = hwnd;

 //ShowWindow(hwnd,nCmdShow);
 ShowWindow(hwnd,SW_HIDE);
 UpdateWindow(hwnd);
 PostMessage(hwnd,WM_COMMAND,TRUE,0);

 while (GetMessage(&msg,NULL,0,0))
 {
	TranslateMessage(&msg);
	DispatchMessage(&msg);
 }

 return msg.wParam;
}
/*************************************************************************
* WndProc
*************************************************************************/
LRESULT WINAPI WndProc(HWND hwnd,UINT message,WPARAM wParam,LPARAM lParam)
{
 TCHAR cWork[25];
 PAINTSTRUCT ps;
 HWND hWork;
 RECT rect;
 int x,y;
 LPTSTR lps,lpx,lpy;


 switch (message)
 {
	case WM_SIZE:
	 break;
  case WM_COMMAND:
   if (wParam)
   {
    hWork = FindMyTSoft();
    if (hWork)
    {
     //set cursor based on command line
     //expects x: or X: and y: or Y:
     x = y = 0;
     lpx = lstrchr((LPTSTR) szCmd,'x');
     lps = lstrchr((LPTSTR) szCmd,'X');
     if ((lps) && (!lpx)) lpx = lps;
     if (lpx)
     {
      lpx += 2;  //past x:
      lps = lstrchr(lpx,' ');
      if (lps) *lps = 0;
      lstrcpy((LPTSTR) cWork,lpx);
      if (lps) *lps = ' ';
      x = _wtoi(cWork);
     }
     lpy = lstrchr((LPTSTR) szCmd,'y');
     lps = lstrchr((LPTSTR) szCmd,'Y');
     if ((lps) && (!lpy)) lpy = lps;
     if (lpy)
     {
      lpy += 2;  //past y:
      lps = lstrchr(lpy,' ');
      if (lps) *lps = 0;
      lstrcpy((LPTSTR) cWork,lpy);
      y = _wtoi(cWork);
     }
     if ((lpx) || (lpy))
     {
      GetWindowRect(hWork,&rect);
      MoveWindow(hWork,x,y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
      //Win32 changed meaning of last parameter - TRUE is required for
      //intended operation for 32-bit versions
      //MoveWindow(hWork,x,y,rect.right-rect.left,rect.bottom-rect.top,FALSE);
     }

     PostMessage(hwnd,WM_CLOSE,0,0);
    }
    else
    {
     //no My-T-Soft found!
     MessageBeep(MB_ICONEXCLAMATION);
     PostMessage(hwnd,WM_CLOSE,0,0);
    }
   }
   return 0;

	case WM_PAINT:
	 BeginPaint(hwnd,&ps);
	 EndPaint(hwnd,&ps);
	 break;
	case WM_LBUTTONDOWN:
	 break;
  case WM_LBUTTONDBLCLK:
	 break;
	case WM_RBUTTONDOWN:
	 break;
  case WM_RBUTTONDBLCLK:
	 break;
	case WM_MBUTTONDOWN:
	 break;

	case WM_CLOSE:
	 DestroyWindow(hwnd);
	 return 0;
	case WM_DESTROY:
	 PostQuitMessage(0);
	 return 0;
 }
 return DefWindowProc(hwnd,message,wParam,lParam);
}
/*************************************************************************
* lstrchr(LPTSTR str,char ch)
*************************************************************************/
LPTSTR lstrchr(LPTSTR str,TCHAR ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = CharNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPTSTR str,char ch)
*************************************************************************/
LPTSTR lstrrchr(LPTSTR str,TCHAR ch)
{
 LPTSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = CharPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPTSTR) TEXT("My-T-Soft"));
 return hTemp;
}
/*************************************************************************
* END OF CODE
*************************************************************************/
