/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2001 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* 1.71 Notes, 3/17/2001
* This source was modified from the MTSVBDLL - the MTSVBDLL source
* will remain untouched in future releases of the Developer's Kit.
* The May 2000 version is its first & final release.
* For My-T-Soft versions 1.70 and above, this is the preferred DLL 
* to use, and any additional enhancements will take place in this 
* source (MTSDLL).
* Examples of integrating this DLL into MS-Access have been included
* and can be reviewed as an example of a general approach to 
* using this DLL to communicate with My-T-Soft from any high-level
* programming environment.  Note that with this DLL (and its source)
* all types of manipulations of the keyboard & its panels are 
* possible - refer to "http://www.imgpresents.com/imgdev.htm" for
* further examples & step-by-step integration scenarios...
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include "mytsoft.h"

/*************************************************************************
* defines
*************************************************************************/
/*************************************************************************
* INI Notes - because of the three products, and different default
* Windows directories (\WINDOWS or \WINNT or \WTSRV, and non-standard 
* possibilities), various soft & hard-coded approached are implemented in
* this DLL to handle default installs, and non-standard ones...
* 
*************************************************************************/

//#define WINPRODKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\My-T-Soft"
#define WINPRODKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\"

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "My-T-Soft Visual Basic DLL";
char szCmd[200];  //location for Window command line
char szDefINI[200] = "C:\\WINNT\\MYTSOFT\\MYTSOFT.INI";
char szMTSINI[200];

BOOL bNonStandardInstall = FALSE;

char cMacFileName[200];
char cBuf[2048];

HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch);
LPSTR lstrrchr(LPSTR str,char ch);
HWND FindMyTSoft(void);
void UpdateDefINI(HWND);
void ParseCmdUpdateIni(void);
void NoMyTSoft(void);

/*************************************************************************
* GetXYMTS
*************************************************************************/
long WINAPI GetXYMTS(long dwType)
{
 HWND hWork;
 RECT rect;
 POINT pPoint = {-0xFFFF,-0xFFFF};
 hWork = FindMyTSoft();
 if (hWork)
 {
  GetWindowRect(hWork,&rect);
  if (dwType == TOPLEFT)
  {
   pPoint.x = rect.left;
   pPoint.y = rect.top;
  }
  if (dwType == BOTTOMRIGHT)
  {
   pPoint.x = rect.right;
   pPoint.y = rect.bottom;
  }
  if (dwType == WIDTHHEIGHT)
  {
   pPoint.x = rect.right-rect.left;
   pPoint.y = rect.bottom-rect.top;
  }
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
 }
 return (MAKELONG(pPoint.x,pPoint.y));
}
/*************************************************************************
* GetXYWnd
*************************************************************************/
long WINAPI GetXYWnd(HWND hWnd, long dwType)
{
 RECT rect;
 POINT pPoint = {-0xFFFF,-0xFFFF};
 GetWindowRect(hWnd,&rect);
 if (dwType == TOPLEFT)
 {
  pPoint.x = rect.left;
  pPoint.y = rect.top;
 }
 if (dwType == BOTTOMRIGHT)
 {
  pPoint.x = rect.right;
  pPoint.y = rect.bottom;
 }
 if (dwType == WIDTHHEIGHT)
 {
  pPoint.x = rect.right-rect.left;
  pPoint.y = rect.bottom-rect.top;
 }
 return (MAKELONG(pPoint.x,pPoint.y));
}
/*************************************************************************
* MoveWindowMTS
*************************************************************************/
long WINAPI MoveWindowMTS(long x, long y)
{
 HWND hWork;
 RECT rect;
 BOOL bRetval = FALSE;
 hWork = FindMyTSoft();
 if (hWork)
 {
  GetWindowRect(hWork,&rect);
  MoveWindow(hWork,x,y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SetCursorPosMTS
*************************************************************************/
long WINAPI SetCursorPosMTS(long x, long y)
{
 SetCursorPos(x,y);
 return TRUE;
}
/*************************************************************************
* LaunchMTS
*************************************************************************/
long WINAPI LaunchMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 LPSTR lps;
 hWork = FindMyTSoft();
 if (hWork)
 {
  MessageBeep(MB_ICONEXCLAMATION);  
 }
 else
 {
  //no My-T-Soft found!
  UpdateDefINI(hWork);
  lstrcpy(cBuf,szDefINI);
  lps = lstrrchr(cBuf,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;
   lstrcat(cBuf,"MYTSOFT.EXE");
   if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
  }  
  if (!bRetval)
  {
   //My-T-Touch
   lstrcpy(cBuf,szDefINI);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTTOUCH.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
  }
  if (!bRetval)
  {
   //My-T-Pen
   lstrcpy(cBuf,szDefINI);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTPEN.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
  }
 }
 return bRetval;
}
/*************************************************************************
* LaunchFromCurrentMTS
* This is used to from Visual Basic code to run My-T-Soft product
* based on passed in path (lpCmd)
* This also sets szDefINI, and sets Global bNonStandardInstall to
* prevent modification if any other DLL call calls UpdateDefINI
*************************************************************************/
long WINAPI LaunchFromCurrentMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 LPSTR lps;
 hWork = FindMyTSoft();
 if (hWork)
 {
  MessageBeep(MB_ICONEXCLAMATION);  
 }
 else
 {
  //no My-T-Soft found!
  lstrcpy(cBuf,lpCmd);
  lps = lstrrchr(cBuf,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;
   lstrcat(cBuf,"MYTSOFT.EXE");
   if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTSOFT.INI");
   }
  }  
  if (!bRetval)
  {
   //My-T-Touch
   lstrcpy(cBuf,lpCmd);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTTOUCH.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTTOUCH.INI");
   }
  }
  if (!bRetval)
  {
   //My-T-Pen
   lstrcpy(cBuf,lpCmd);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTPEN.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTPEN.INI");
   }
  }
 }
 bNonStandardInstall = bRetval;
 return bRetval;
}
/*************************************************************************
* CloseMTS
*************************************************************************/
long WINAPI CloseMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 hWork = FindMyTSoft();
 if (hWork)
 {
		SendMessage(hWork,WM_CLOSE,0,0L);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* MinimizeMTS
*************************************************************************/
long WINAPI MinimizeMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_ICON,1L);  //min to button
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* OpenMTS
*************************************************************************/
long WINAPI OpenMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_OPEN,0L);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SaveSettingsMTS
*************************************************************************/
long WINAPI SaveSettingsMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_SAVESETTINGS,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SavePositionMTS
*************************************************************************/
long WINAPI SavePositionMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_SAVEPOSITION,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* RestoreSettingsMTS
*************************************************************************/
long WINAPI RestoreSettingsMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* RestorePositionMTS
*************************************************************************/
long WINAPI RestorePositionMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTPOSITION,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* ConfigureMTS
*************************************************************************/
long WINAPI ConfigureMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
  wMessage1 = RegisterWindowMessage(MYT_MSG1);
  ShowWindow(hWork,SW_HIDE);

  UpdateDefINI(hWork);
  lstrcpy(szMTSINI,szDefINI);

  lstrcpy(szCmd,lpCmd);

  ParseCmdUpdateIni();

  SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_UPDATE,0));
  ShowWindow(hWork,SW_SHOW);

  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SendStringMTS
*************************************************************************/
long WINAPI SendStringMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 LPSTR lps;
 HFILE hFile;
 OFSTRUCT of;

 hWork = FindMyTSoft();
 if (hWork)
 {
  wMessage1 = RegisterWindowMessage(MYT_MSG1);
  lstrcpy(cBuf,lpCmd);

  UpdateDefINI(hWork);
  lstrcpy(cMacFileName,szDefINI);

  lps = lstrrchr(cMacFileName,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;   
   lstrcat((LPSTR) cMacFileName,(LPSTR) "SDSTRMTS.KMF");
  }


  hFile = OpenFile((LPCSTR) cMacFileName,(OFSTRUCT FAR *) &of,
						OF_CREATE | OF_READWRITE);
  _lwrite(hFile,(LPCSTR) &cBuf,lstrlen(cBuf));
  _lclose(hFile);
	 
  SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELPARAM(MYTMSGREQ_SENDSTR,0));

  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* CopyConfigureMTS
*************************************************************************/
long WINAPI CopyConfigureMTS(LPSTR lpCmd)
{
 BOOL bRetval = FALSE;
 HWND hWork;
 UINT wMessage1;
 LPSTR lpData;
 char szFile1[MAX_PATH];
 char szFile2[MAX_PATH];

 if (lstrlen(lpCmd))
 {
  hWork = FindMyTSoft();
  if (hWork)
  {
		 wMessage1 = RegisterWindowMessage(MYT_MSG1);
   ShowWindow(hWork,SW_HIDE);
 
   UpdateDefINI(hWork);
   lstrcpy(szMTSINI,szDefINI);

   //szFile1 - if Path, leave alone, strip spaces
   //if No path, prepend default path from above
   lstrcpy((LPSTR) szFile1,(LPSTR) lpCmd);

   lpData = lstrchr(lpCmd,'\\');
   if (lpData)
   {
    lpData = (LPSTR) lpCmd;
    while ((*lpData) == ' ') lpData++;
    lstrcpy((LPSTR) szFile1,lpData);
   }
   else
   {
    //no path
    lstrcpy((LPSTR) szFile1,(LPSTR) szMTSINI);
    lpData = lstrrchr((LPSTR) szFile1,'\\');
    if (lpData)
    {
     lpData++;
     *lpData = 0; //end string past backslash
     lpData = (LPSTR) lpCmd;
     while ((*lpData) == ' ') lpData++;
     lstrcat((LPSTR) szFile1,(LPSTR) lpData);
    }
   }
   //File2 gets KEYBOARD.KBF in default dir
   lstrcpy((LPSTR) szFile2,(LPSTR) szMTSINI);
   lpData = lstrrchr((LPSTR) szFile2,'\\');
   if (lpData)
   {
    lpData++;
    *lpData = 0; //end string past backslash
    lstrcat((LPSTR) szFile2,(LPSTR) "KEYBOARD.KBF");
   }

   if (CopyFile(szFile1,szFile2,FALSE))
   {
    SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
    bRetval = TRUE;
   }
   ShowWindow(hWork,SW_SHOW);   
  }
  else
  {
   //no My-T-Soft found!
   NoMyTSoft();
  }
 }
 return bRetval;
}
/*************************************************************************
* ToggleConfigureMTS
*************************************************************************/
long WINAPI ToggleConfigureMTS(LPSTR lpCmd)
{
 BOOL bRetval = FALSE;
 HWND hWork;
 UINT wMessage1;
 LPSTR lpData;
 RECT rect;
 char szFile1[MAX_PATH];
 char szFile2[MAX_PATH];

 if (lstrlen(lpCmd))
 {
  hWork = FindMyTSoft();
  if (hWork)
  {
   //find out if window is already displayed on visible part of screen
   //1 monitor assumed
   //if window is visible, move off screen & leav
   GetWindowRect(hWork,&rect);
   if (rect.left < GetSystemMetrics(SM_CXSCREEN))
   {
    MoveWindow(hWork,GetSystemMetrics(SM_CXSCREEN),0,rect.right-rect.left,rect.bottom-rect.top,TRUE);   
    return TRUE;
   }
   //
		 wMessage1 = RegisterWindowMessage(MYT_MSG1);
   ShowWindow(hWork,SW_HIDE);
 
   UpdateDefINI(hWork);
   lstrcpy(szMTSINI,szDefINI);

   //szFile1 - if Path, leave alone, strip spaces
   //if No path, prepend default path from above
   lstrcpy((LPSTR) szFile1,(LPSTR) lpCmd);

   lpData = lstrchr(lpCmd,'\\');
   if (lpData)
   {
    lpData = (LPSTR) lpCmd;
    while ((*lpData) == ' ') lpData++;
    lstrcpy((LPSTR) szFile1,lpData);
   }
   else
   {
    //no path
    lstrcpy((LPSTR) szFile1,(LPSTR) szMTSINI);
    lpData = lstrrchr((LPSTR) szFile1,'\\');
    if (lpData)
    {
     lpData++;
     *lpData = 0; //end string past backslash
     lpData = (LPSTR) lpCmd;
     while ((*lpData) == ' ') lpData++;
     lstrcat((LPSTR) szFile1,(LPSTR) lpData);
    }
   }
   //File2 gets KEYBOARD.KBF in default dir
   lstrcpy((LPSTR) szFile2,(LPSTR) szMTSINI);
   lpData = lstrrchr((LPSTR) szFile2,'\\');
   if (lpData)
   {
    lpData++;
    *lpData = 0; //end string past backslash
    lstrcat((LPSTR) szFile2,(LPSTR) "KEYBOARD.KBF");
   }

   if (CopyFile(szFile1,szFile2,FALSE))
   {
    SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
    bRetval = TRUE;
   }
   ShowWindow(hWork,SW_SHOW);   
  }
  else
  {
   //no My-T-Soft found!
   NoMyTSoft();
  }
 }
 return bRetval;
}

/*************************************************************************
* lstrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = AnsiNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrrchr(LPSTR str,char ch)
{
 LPSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = AnsiPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Touch");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Pen");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "TouchType");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "FastPoint");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "EasyKey");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "JobPack");
 return hTemp;
}
/*************************************************************************
* ParseCmdUpdateIni
*************************************************************************/
void ParseCmdUpdateIni(void)
{
 LPSTR lps;
 int i;
 char cWork[200];

 AnsiUpperBuff(szCmd,200);

 lps = (LPSTR) szCmd;
 while (lps)
 {
  lps = lstrchr((LPSTR) lps,'/');
  if (!lps) break;
  lps++;  //to letter
  switch (*lps)
  {
   case 'K':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'E':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'N':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'C':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'M':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'W':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'T':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'S':
    lps++;
    if (*lps == ':')
    {
     lps++;
     i = 0;
     cWork[i] = *lps;
     if (cWork[i] == '1')
     {
      lps++;
      i++;
      cWork[i] = *lps;
     }
     cWork[i+1] = 0;
     if ((atoi(cWork) >= 1) && (atoi(cWork) <= 12))  ;//OK 
     else 
     {
      lstrcpy(cWork,"12");
      MessageBeep(MB_ICONEXCLAMATION);
     }

     WritePrivateProfileString((LPSTR) "Configuration",(LPSTR) "Size",
       (LPSTR) cWork,(LPSTR) szMTSINI);
    }
    break;
  }//switch
 }  //while
}
/*************************************************************************
* UpdateDefINI ties specific default INI files to
*************************************************************************/
void UpdateDefINI(HWND hWnd)
{
 TCHAR cWork[250];
 TCHAR szRegKey[500];
 HKEY keyH;
 DWORD dwValue;
 DWORD dwSize;
 LPSTR lps;
 int i;

 //assume DefINI setting at LaunchFromCurrentMTS is correct...
 //DO NOT MODIFY!
 if (bNonStandardInstall) return;

 if (hWnd)
 {
  if (GetWindowText(hWnd,(LPSTR) cWork,29))
  {
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Soft"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTSOFT\\MYTSOFT.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTSOFT.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Touch"))
   {
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTTOUCH\\MYTTOUCH.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTTOUCH.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Pen"))
   {
    //lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    i = GetWindowsDirectory((LPSTR) szDefINI,sizeof(szDefINI)); 
    if (szDefINI[i-1] != '\\') lstrcat((LPSTR) szDefINI,(LPSTR) "\\");
    lstrcat((LPSTR) szDefINI,(LPSTR) "MYTPEN\\MYTPEN.INI");
    //this is default location, unless registry key in place
    //registry overwrite from hardcoded Default
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) cWork);
    
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
  }  //GetWindowText has a string
 }
 else  //hWnd is NULL
 {
  szDefINI[0] = 0; // null INI string

  //Try all 3 products, start with My-T-Soft
  lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
  lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Soft");

  dwValue = REG_SZ;
  dwSize = sizeof(cWork);

  cWork[0] = 0;
  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
  {  
   if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
   {
    //See if value, then rework szDefINI
    if (lstrlen(cWork) > 0)
    {
     lps = lstrrchr(cWork,'\\');
     if (lps)
     {
      lps++;
      *lps = 0;
      lstrcat(cWork,"MYTSOFT.INI");
      lstrcpy(szDefINI,cWork);
     }
    }
   }
   RegCloseKey(keyH);
  }
  else //fail on My-T-Soft
  {
   lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
   lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Touch");

   dwValue = REG_SZ;
   dwSize = sizeof(cWork);

   cWork[0] = 0;
   if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
   {  
    if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
    {
     //See if value, then rework szDefINI
     if (lstrlen(cWork) > 0)
     {
      lps = lstrrchr(cWork,'\\');
      if (lps)
      {
       lps++;
       *lps = 0;
       lstrcat(cWork,"MYTTOUCH.INI");
       lstrcpy(szDefINI,cWork);
      }
     }
    }
    RegCloseKey(keyH);
   }
   else  //fail on My-T-Touch
   {
    lstrcpy((LPSTR) szRegKey,(LPSTR) WINPRODKEY);
    lstrcat((LPSTR) szRegKey,(LPSTR) "My-T-Pen");

    dwValue = REG_SZ;
    dwSize = sizeof(cWork);

    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,szRegKey,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefINI
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTPEN.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    } //fail on My-T-Pen
   } //fail on My-T-Touch
  } //fail on My-T-Soft
 } //hWnd 
}
/*************************************************************************
* NoMyTSoft
*************************************************************************/
void NoMyTSoft(void)
{
 MessageBeep(MB_ICONEXCLAMATION);
 MessageBox(NULL,"For proper operation, My-T-Soft/My-T-Touch/My-T-Pen must be running!","MTSDLL Error: My-T-Soft/My-T-Touch/My-T-Pen NOT FOUND!",MB_OK | MB_ICONEXCLAMATION);
}
/*************************************************************************
* END OF CODE
*************************************************************************/
