// MTSEditProp.h : Declaration of the CMTSEditProp

#ifndef __MTSEDITPROP_H_
#define __MTSEDITPROP_H_

#include "resource.h"       // main symbols

EXTERN_C const CLSID CLSID_MTSEditProp;

/////////////////////////////////////////////////////////////////////////////
// CMTSEditProp
class ATL_NO_VTABLE CMTSEditProp :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CMTSEditProp, &CLSID_MTSEditProp>,
	public IPropertyPageImpl<CMTSEditProp>,
	public CDialogImpl<CMTSEditProp>
{
public:
	CMTSEditProp() 
	{
		m_dwTitleID = IDS_TITLEMTSEditProp;
		m_dwHelpFileID = IDS_HELPFILEMTSEditProp;
		m_dwDocStringID = IDS_DOCSTRINGMTSEditProp;
	}

	enum {IDD = IDD_MTSEDITPROP};

DECLARE_REGISTRY_RESOURCEID(IDR_MTSEDITPROP)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CMTSEditProp) 
	COM_INTERFACE_ENTRY(IPropertyPage)
END_COM_MAP()

BEGIN_MSG_MAP(CMTSEditProp)
	CHAIN_MSG_MAP(IPropertyPageImpl<CMTSEditProp>)
	COMMAND_HANDLER(IDC_OFF_X, EN_CHANGE, OnChangeOff_x)
	COMMAND_HANDLER(IDC_OFF_Y, EN_CHANGE, OnChangeOff_y)
	COMMAND_HANDLER(IDC_ON_X, EN_CHANGE, OnChangeOn_x)
	COMMAND_HANDLER(IDC_ON_Y, EN_CHANGE, OnChangeOn_y)
	COMMAND_HANDLER(IDC_ENTIRE, BN_CLICKED, OnClickedEntire)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	STDMETHOD(Apply)(void)
	{
		ATLTRACE(_T("CMTSEditProp::Apply\n"));
		for (UINT i = 0; i < m_nObjects; i++)
		{
   CComQIPtr<IMyTSoftEdit, &IID_IMyTSoftEdit> pMyTS(m_ppUnk[i]);
   pMyTS->put_OnX(GetDlgItemInt(IDC_ON_X));
   pMyTS->put_OnY(GetDlgItemInt(IDC_ON_Y));
   pMyTS->put_OffX(GetDlgItemInt(IDC_OFF_X));
   pMyTS->put_OffY(GetDlgItemInt(IDC_OFF_Y));
   pMyTS->put_bEntireWindowVisible(IsDlgButtonChecked(IDC_ENTIRE));
			// Do something interesting here
			// ICircCtl* pCirc;
			// m_ppUnk[i]->QueryInterface(IID_ICircCtl, (void**)&pCirc);
			// pCirc->put_Caption(CComBSTR("something special"));
			// pCirc->Release();
		}
		m_bDirty = FALSE;
		return S_OK;
	}
	LRESULT OnChangeOff_x(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
  SetDirty(TRUE);
 	return 0;
	}
	LRESULT OnChangeOff_y(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
  SetDirty(TRUE);
		return 0;
	}
	LRESULT OnChangeOn_x(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
  SetDirty(TRUE);
		return 0;
	}
	LRESULT OnChangeOn_y(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
  SetDirty(TRUE);
		return 0;
	}
	LRESULT OnClickedEntire(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
  SetDirty(TRUE);
		return 0;
	}
	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
  for (UINT i = 0; i < m_nObjects; i++)
  {
   long Result;
   CComQIPtr<IMyTSoftEdit, &IID_IMyTSoftEdit> pMyTS(m_ppUnk[i]);
   pMyTS->get_OnX(&Result);
   SetDlgItemInt(IDC_ON_X,Result,TRUE);
   pMyTS->get_OnY(&Result);
   SetDlgItemInt(IDC_ON_Y,Result,TRUE);
   pMyTS->get_OffX(&Result);
   SetDlgItemInt(IDC_OFF_X,Result,TRUE);
   pMyTS->get_OffY(&Result);
   SetDlgItemInt(IDC_OFF_Y,Result,TRUE);
   pMyTS->get_bEntireWindowVisible(&Result);
   CheckDlgButton(IDC_ENTIRE,Result);
  }
		return 0;
	}
};

#endif //__MTSEDITPROP_H_
