// MyTSoftEdit.h : Declaration of the CMyTSoftEdit

#ifndef __MYTSOFTEDIT_H_
#define __MYTSOFTEDIT_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include "MTSEDITCP.h"


/////////////////////////////////////////////////////////////////////////////
// CMyTSoftEdit
class ATL_NO_VTABLE CMyTSoftEdit : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IMyTSoftEdit, &IID_IMyTSoftEdit, &LIBID_MTSEDITLib>,
	public CComControl<CMyTSoftEdit>,
	public IPersistStreamInitImpl<CMyTSoftEdit>,
	public IOleControlImpl<CMyTSoftEdit>,
	public IOleObjectImpl<CMyTSoftEdit>,
	public IOleInPlaceActiveObjectImpl<CMyTSoftEdit>,
	public IViewObjectExImpl<CMyTSoftEdit>,
	public IOleInPlaceObjectWindowlessImpl<CMyTSoftEdit>,
	public ISupportErrorInfo,
	public IConnectionPointContainerImpl<CMyTSoftEdit>,
	public IPersistStorageImpl<CMyTSoftEdit>,
	public ISpecifyPropertyPagesImpl<CMyTSoftEdit>,
	public IQuickActivateImpl<CMyTSoftEdit>,
	public IDataObjectImpl<CMyTSoftEdit>,
	public IProvideClassInfo2Impl<&CLSID_MyTSoftEdit, &DIID__IMyTSoftEditEvents, &LIBID_MTSEDITLib>,
	public IPropertyNotifySinkCP<CMyTSoftEdit>,
	public CComCoClass<CMyTSoftEdit, &CLSID_MyTSoftEdit>,
	public CProxy_IMyTSoftEditEvents< CMyTSoftEdit >
{
public:
	CContainedWindow m_ctlEdit;
	

	CMyTSoftEdit() :	
		m_ctlEdit(_T("Edit"), this, 1)
	{
		m_bWindowOnly = TRUE;
  //Use - numbers for relative positioning
  OnX = OnY = -10; 
  OffX = OffY = GetSystemMetrics(SM_CXSCREEN);
  bEntireWindowVisible = TRUE;

	}

DECLARE_REGISTRY_RESOURCEID(IDR_MYTSOFTEDIT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CMyTSoftEdit)
	COM_INTERFACE_ENTRY(IMyTSoftEdit)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
	COM_INTERFACE_ENTRY(IProvideClassInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY_IMPL(IConnectionPointContainer)
END_COM_MAP()

BEGIN_PROP_MAP(CMyTSoftEdit)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
 PROP_ENTRY("Properties", 1, CLSID_MTSEditProp)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_CONNECTION_POINT_MAP(CMyTSoftEdit)
	CONNECTION_POINT_ENTRY(IID_IPropertyNotifySink)
	CONNECTION_POINT_ENTRY(DIID__IMyTSoftEditEvents)
END_CONNECTION_POINT_MAP()

BEGIN_MSG_MAP(CMyTSoftEdit)
	MESSAGE_HANDLER(WM_CREATE, OnCreate)
	MESSAGE_HANDLER(WM_SETFOCUS, OnSetFocus)
	CHAIN_MSG_MAP(CComControl<CMyTSoftEdit>)
ALT_MSG_MAP(1)
	// Replace this with message map entries for superclassed Edit
	MESSAGE_HANDLER(WM_KILLFOCUS, OnKillFocus)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	BOOL PreTranslateAccelerator(LPMSG pMsg, HRESULT& hRet)
	{
		if(pMsg->message == WM_KEYDOWN && 
			(pMsg->wParam == VK_LEFT || 
			pMsg->wParam == VK_RIGHT ||
			pMsg->wParam == VK_UP ||
			pMsg->wParam == VK_DOWN))
		{
			hRet = S_FALSE;
			return TRUE;
		}
		//TODO: Add your additional accelerator handling code here
		return FALSE;
	}

	LRESULT OnSetFocus(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		LRESULT lRes = CComControl<CMyTSoftEdit>::OnSetFocus(uMsg, wParam, lParam, bHandled);

  //added so our code will "talk" to My-T-Soft window
	 CMyTSoftEdit::HandleFocusIn(); 

 	if (m_bInPlaceActive)
		{
			DoVerbUIActivate(&m_rcPos,  NULL);
			if(!IsChild(::GetFocus()))
				m_ctlEdit.SetFocus();
		}
		return lRes;
	}

	LRESULT OnCreate(UINT /*uMsg*/, WPARAM /*wParam*/, LPARAM /*lParam*/, BOOL& /*bHandled*/)
	{
		RECT rc;
		GetWindowRect(&rc);

		rc.right -= rc.left;
		rc.bottom -= rc.top;
		rc.top = rc.left = 0;
		m_ctlEdit.Create(m_hWnd, rc);
		return 0;
	}
	STDMETHOD(SetObjectRects)(LPCRECT prcPos,LPCRECT prcClip)
	{
		IOleInPlaceObjectWindowlessImpl<CMyTSoftEdit>::SetObjectRects(prcPos, prcClip);
		int cx, cy;
		cx = prcPos->right - prcPos->left;
		cy = prcPos->bottom - prcPos->top;
		::SetWindowPos(m_ctlEdit.m_hWnd, NULL, 0,
			0, cx, cy, SWP_NOZORDER | SWP_NOACTIVATE);
		return S_OK;
	}

// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid)
	{
		static const IID* arr[] = 
		{
			&IID_IMyTSoftEdit,
		};
		for (int i=0; i<sizeof(arr)/sizeof(arr[0]); i++)
		{
			if (InlineIsEqualGUID(*arr[i], riid))
				return S_OK;
		}
		return S_FALSE;
	}

// IViewObjectEx
	DECLARE_VIEW_STATUS(VIEWSTATUS_SOLIDBKGND | VIEWSTATUS_OPAQUE)

// IMyTSoftEdit
public:
	STDMETHOD(HandleFocusOut)();
	STDMETHOD(HandleFocusIn)();
 long OnX;
 long OnY;
 long OffX;
 long OffY;
 long bEntireWindowVisible;
	STDMETHOD(get_bEntireWindowVisible)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_bEntireWindowVisible)(/*[in]*/ long newVal);
	STDMETHOD(get_OffY)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_OffY)(/*[in]*/ long newVal);
	STDMETHOD(get_OffX)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_OffX)(/*[in]*/ long newVal);
	STDMETHOD(get_OnY)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_OnY)(/*[in]*/ long newVal);
	STDMETHOD(get_OnX)(/*[out, retval]*/ long *pVal);
	STDMETHOD(put_OnX)(/*[in]*/ long newVal);
	LRESULT OnKillFocus(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
		LRESULT lRes = CComControl<CMyTSoftEdit>::OnKillFocus(uMsg, wParam, lParam, bHandled);
		//added so our code will "talk" to My-T-Soft window
	 CMyTSoftEdit::HandleFocusOut(); 
  return lRes;
	}
};

#endif //__MYTSOFTEDIT_H_
