/*************************************************************************
* My-T-Soft Utility
* Copyright (C) 1997-2000 by Innovation Management Group, Inc.
* All Rights Reserved.
*************************************************************************/
/*************************************************************************
* DISCLAIMER
* The source code & derived executable are provided at no cost as
* useful & instructional materials to developers & system integrators
* incorporating IMG software.  Because no licensing fee has been
* tendered, there is no technical support offered for this software,
* source code, or its capabilities to solve a particular problem.
*************************************************************************/
/*************************************************************************
* Base Windows structure w/ debug source
* Modified Utility Source for application that Closes My-T-Soft
* & exits with no other actions, no Window display
* Note: Various variables and other window work left in place, but
* has no effect for this application
*************************************************************************/
/*************************************************************************
* START OF CODE
*************************************************************************/
/*************************************************************************
* includes
*************************************************************************/
#include <windows.h>
#include <stdlib.h>
#include "mytsoft.h"

/*************************************************************************
* defines
*************************************************************************/
#define WINPRODKEY "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\My-T-Soft"

/*************************************************************************
* Variables
*************************************************************************/

char szAppName[30] = "My-T-Soft Visual Basic DLL";
char szCmd[200];  //location for Window command line
char szDefINI[200] = "C:\\WINNT\\MYTSOFT\\MYTSOFT.INI";
char szMTSINI[200];

BOOL bNonStandardInstall = FALSE;

char cMacFileName[200];
char cBuf[2048];

HWND hWindow;
HANDLE hInst;

HANDLE hIns;

int OrgX,OrgY,OrgW,OrgH;
int OffsetX,OffsetY;
int MaxX,MaxY,MinX,MinY;

/*************************************************************************
* Functions
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch);
LPSTR lstrrchr(LPSTR str,char ch);
HWND FindMyTSoft(void);
void UpdateDefINI(HWND);
void ParseCmdUpdateIni(void);
void NoMyTSoft(void);

/*************************************************************************
* MoveWindowMTS
*************************************************************************/
long WINAPI MoveWindowMTS(long x, long y)
{
 HWND hWork;
 RECT rect;
 BOOL bRetval = FALSE;
 hWork = FindMyTSoft();
 if (hWork)
 {
  GetWindowRect(hWork,&rect);
  MoveWindow(hWork,x,y,rect.right-rect.left,rect.bottom-rect.top,TRUE);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SetCursorPosMTS
*************************************************************************/
long WINAPI SetCursorPosMTS(long x, long y)
{
 SetCursorPos(x,y);
 return TRUE;
}
/*************************************************************************
* LaunchMTS
*************************************************************************/
long WINAPI LaunchMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 LPSTR lps;
 hWork = FindMyTSoft();
 if (hWork)
 {
  MessageBeep(MB_ICONEXCLAMATION);  
 }
 else
 {
  //no My-T-Soft found!
  UpdateDefINI(hWork);
  lstrcpy(cBuf,szDefINI);
  lps = lstrrchr(cBuf,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;
   lstrcat(cBuf,"MYTSOFT.EXE");
   if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
  }  
  if (!bRetval)
  {
   //My-T-Touch
   lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINDOWS\\MYTTOUCH\\MYTTOUCH.INI");
   lstrcpy(cBuf,szDefINI);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTTOUCH.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
  }
  if (!bRetval)
  {
   //My-T-Pen
   lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINDOWS\\MYTPEN\\MYTPEN.INI");
   lstrcpy(cBuf,szDefINI);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTPEN.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
  }
 }
 return bRetval;
}
/*************************************************************************
* LaunchFromCurrentMTS
*************************************************************************/
long WINAPI LaunchFromCurrentMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 LPSTR lps;
 hWork = FindMyTSoft();
 if (hWork)
 {
  MessageBeep(MB_ICONEXCLAMATION);  
 }
 else
 {
  //no My-T-Soft found!

  lstrcpy(cBuf,lpCmd);
  lps = lstrrchr(cBuf,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;
   lstrcat(cBuf,"MYTSOFT.EXE");
   if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTSOFT.INI");
   }
  }  
  if (!bRetval)
  {
   //My-T-Touch
   lstrcpy(cBuf,lpCmd);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTTOUCH.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTTOUCH.INI");
   }
  }
  if (!bRetval)
  {
   //My-T-Pen
   lstrcpy(cBuf,lpCmd);
   lps = lstrrchr(cBuf,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(cBuf,"MYTPEN.EXE");
    if (WinExec(cBuf,SW_SHOW) > 32) bRetval = TRUE;
   }  
   lstrcpy(szDefINI,lpCmd);
   lps = lstrrchr(szDefINI,'\\');
   if (lps)
   {
    lps++;
    *lps = 0;
    lstrcat(szDefINI,"MYTPEN.INI");
   }
  }
 }
 bNonStandardInstall = bRetval;
 return bRetval;
}
/*************************************************************************
* CloseMTS
*************************************************************************/
long WINAPI CloseMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 hWork = FindMyTSoft();
 if (hWork)
 {
		SendMessage(hWork,WM_CLOSE,0,0L);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* MinimizeMTS
*************************************************************************/
long WINAPI MinimizeMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_ICON,1L);  //min to button
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* OpenMTS
*************************************************************************/
long WINAPI OpenMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_OPEN,0L);
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SaveSettingsMTS
*************************************************************************/
long WINAPI SaveSettingsMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_SAVESETTINGS,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SavePositionMTS
*************************************************************************/
long WINAPI SavePositionMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_SAVEPOSITION,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* RestoreSettingsMTS
*************************************************************************/
long WINAPI RestoreSettingsMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* RestorePositionMTS
*************************************************************************/
long WINAPI RestorePositionMTS(void)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
		wMessage1 = RegisterWindowMessage(MYT_MSG1);
		SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTPOSITION,0));
  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* ConfigureMTS
*************************************************************************/
long WINAPI ConfigureMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 hWork = FindMyTSoft();
 if (hWork)
 {
  wMessage1 = RegisterWindowMessage(MYT_MSG1);
  ShowWindow(hWork,SW_HIDE);

  UpdateDefINI(hWork);
  lstrcpy(szMTSINI,szDefINI);

  lstrcpy(szCmd,lpCmd);

  ParseCmdUpdateIni();

  SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_UPDATE,0));
  ShowWindow(hWork,SW_SHOW);

  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* SendStringMTS
*************************************************************************/
long WINAPI SendStringMTS(LPSTR lpCmd)
{
 HWND hWork;
 BOOL bRetval = FALSE;
 UINT wMessage1;
 LPSTR lps;
 HFILE hFile;
 OFSTRUCT of;

 hWork = FindMyTSoft();
 if (hWork)
 {
  wMessage1 = RegisterWindowMessage(MYT_MSG1);
  lstrcpy(cBuf,lpCmd);

  UpdateDefINI(hWork);
  lstrcpy(cMacFileName,szDefINI);

  lps = lstrrchr(cMacFileName,'\\');
  if (lps)
  {
   lps++;
   *lps = 0;   
   lstrcat((LPSTR) cMacFileName,(LPSTR) "SDSTRMTS.KMF");
  }


  hFile = OpenFile((LPCSTR) cMacFileName,(OFSTRUCT FAR *) &of,
						OF_CREATE | OF_READWRITE);
  _lwrite(hFile,(LPCSTR) &cBuf,lstrlen(cBuf));
  _lclose(hFile);
	 
  SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELPARAM(MYTMSGREQ_SENDSTR,0));

  bRetval = TRUE;
 }
 else
 {
  //no My-T-Soft found!
  NoMyTSoft();
  
 }
 return bRetval;
}
/*************************************************************************
* CopyConfigureMTS
*************************************************************************/
long WINAPI CopyConfigureMTS(LPSTR lpCmd)
{
 BOOL bRetval = FALSE;
 HWND hWork;
 UINT wMessage1;
 LPSTR lpData;
 char szFile1[MAX_PATH];
 char szFile2[MAX_PATH];

 if (lstrlen(lpCmd))
 {
  hWork = FindMyTSoft();
  if (hWork)
  {
		 wMessage1 = RegisterWindowMessage(MYT_MSG1);
   ShowWindow(hWork,SW_HIDE);
 
   UpdateDefINI(hWork);
   lstrcpy(szMTSINI,szDefINI);

   //szFile1 - if Path, leave alone, strip spaces
   //if No path, prepend default path from above
   lstrcpy((LPSTR) szFile1,(LPSTR) lpCmd);

   lpData = lstrchr(lpCmd,'\\');
   if (lpData)
   {
    lpData = (LPSTR) lpCmd;
    while ((*lpData) == ' ') lpData++;
    lstrcpy((LPSTR) szFile1,lpData);
   }
   else
   {
    //no path
    lstrcpy((LPSTR) szFile1,(LPSTR) szMTSINI);
    lpData = lstrrchr((LPSTR) szFile1,'\\');
    if (lpData)
    {
     lpData++;
     *lpData = 0; //end string past backslash
     lpData = (LPSTR) lpCmd;
     while ((*lpData) == ' ') lpData++;
     lstrcat((LPSTR) szFile1,(LPSTR) lpData);
    }
   }
   //File2 gets KEYBOARD.KBF in default dir
   lstrcpy((LPSTR) szFile2,(LPSTR) szMTSINI);
   lpData = lstrrchr((LPSTR) szFile2,'\\');
   if (lpData)
   {
    lpData++;
    *lpData = 0; //end string past backslash
    lstrcat((LPSTR) szFile2,(LPSTR) "KEYBOARD.KBF");
   }

   if (CopyFile(szFile1,szFile2,FALSE))
   {
    SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
    bRetval = TRUE;
   }
   ShowWindow(hWork,SW_SHOW);   
  }
  else
  {
   //no My-T-Soft found!
   NoMyTSoft();
  }
 }
 return bRetval;
}
/*************************************************************************
* ToggleConfigureMTS
*************************************************************************/
long WINAPI ToggleConfigureMTS(LPSTR lpCmd)
{
 BOOL bRetval = FALSE;
 HWND hWork;
 UINT wMessage1;
 LPSTR lpData;
 RECT rect;
 char szFile1[MAX_PATH];
 char szFile2[MAX_PATH];

 if (lstrlen(lpCmd))
 {
  hWork = FindMyTSoft();
  if (hWork)
  {
   //find out if window is already displayed on visible part of screen
   //1 monitor assumed
   //if window is visible, move off screen & leav
   GetWindowRect(hWork,&rect);
   if (rect.left < GetSystemMetrics(SM_CXSCREEN))
   {
    MoveWindow(hWork,GetSystemMetrics(SM_CXSCREEN),0,rect.right-rect.left,rect.bottom-rect.top,TRUE);   
    return TRUE;
   }
   //
		 wMessage1 = RegisterWindowMessage(MYT_MSG1);
   ShowWindow(hWork,SW_HIDE);
 
   UpdateDefINI(hWork);
   lstrcpy(szMTSINI,szDefINI);

   //szFile1 - if Path, leave alone, strip spaces
   //if No path, prepend default path from above
   lstrcpy((LPSTR) szFile1,(LPSTR) lpCmd);

   lpData = lstrchr(lpCmd,'\\');
   if (lpData)
   {
    lpData = (LPSTR) lpCmd;
    while ((*lpData) == ' ') lpData++;
    lstrcpy((LPSTR) szFile1,lpData);
   }
   else
   {
    //no path
    lstrcpy((LPSTR) szFile1,(LPSTR) szMTSINI);
    lpData = lstrrchr((LPSTR) szFile1,'\\');
    if (lpData)
    {
     lpData++;
     *lpData = 0; //end string past backslash
     lpData = (LPSTR) lpCmd;
     while ((*lpData) == ' ') lpData++;
     lstrcat((LPSTR) szFile1,(LPSTR) lpData);
    }
   }
   //File2 gets KEYBOARD.KBF in default dir
   lstrcpy((LPSTR) szFile2,(LPSTR) szMTSINI);
   lpData = lstrrchr((LPSTR) szFile2,'\\');
   if (lpData)
   {
    lpData++;
    *lpData = 0; //end string past backslash
    lstrcat((LPSTR) szFile2,(LPSTR) "KEYBOARD.KBF");
   }

   if (CopyFile(szFile1,szFile2,FALSE))
   {
    SendMessage(hWork,wMessage1,MYTMSG_REQUEST,MAKELONG(MYTMSGREQ_RESTSETTINGS,0));
    bRetval = TRUE;
   }
   ShowWindow(hWork,SW_SHOW);   
  }
  else
  {
   //no My-T-Soft found!
   NoMyTSoft();
  }
 }
 return bRetval;
}

/*************************************************************************
* lstrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrchr(LPSTR str,char ch)
{
 while (*str)
 {
	if (ch == *str) return str;
	str = AnsiNext(str);
 }
 return NULL;
}
/*************************************************************************
* lstrrchr(LPSTR str,char ch)
*************************************************************************/
LPSTR lstrrchr(LPSTR str,char ch)
{
 LPSTR strl = str + lstrlen(str);
 do
 {
	if (ch == *strl) return strl;
	strl = AnsiPrev(str,strl);
 } while (strl > str);
 return NULL;
}
/*************************************************************************
* FindMyTSoft identifies handle of window in My-T-Soft Family
*************************************************************************/
HWND FindMyTSoft(void)
{
 HWND hTemp;

 // Should be a library function, but want it available for users
 // of developer's kit to play with...

 hTemp = FindWindow(NULL,(LPSTR) "My-T-Soft");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Touch");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Pen");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "My-T-Mouse for Kids");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "TouchType");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "FastPoint");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "EasyKey");
 if (!hTemp) hTemp = FindWindow(NULL,(LPSTR) "JobPack");
 return hTemp;
}
/*************************************************************************
* ParseCmdUpdateIni
*************************************************************************/
void ParseCmdUpdateIni(void)
{
 LPSTR lps;
 int i;
 char cWork[200];

 AnsiUpperBuff(szCmd,200);

 lps = (LPSTR) szCmd;
 while (lps)
 {
  lps = lstrchr((LPSTR) lps,'/');
  if (!lps) break;
  lps++;  //to letter
  switch (*lps)
  {
   case 'K':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Alpha",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'E':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Edit",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'N':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Numeric",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'C':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Calc",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'M':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MacroBrd",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'W':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "Window",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'T':
    lps++;
    if (*lps == '-')
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "0",(LPSTR) szMTSINI);
    }
    else
    {
     WritePrivateProfileString((LPSTR) "StartUp",(LPSTR) "MytCtl",
       (LPSTR) "1",(LPSTR) szMTSINI);
    }
    break;
   case 'S':
    lps++;
    if (*lps == ':')
    {
     lps++;
     i = 0;
     cWork[i] = *lps;
     if (cWork[i] == '1')
     {
      lps++;
      i++;
      cWork[i] = *lps;
     }
     cWork[i+1] = 0;
     if ((atoi(cWork) >= 1) && (atoi(cWork) <= 12))  ;//OK 
     else 
     {
      lstrcpy(cWork,"12");
      MessageBeep(MB_ICONEXCLAMATION);
     }

     WritePrivateProfileString((LPSTR) "Configuration",(LPSTR) "Size",
       (LPSTR) cWork,(LPSTR) szMTSINI);
    }
    break;
  }//switch
 }  //while
}
/*************************************************************************
* UpdateDefINI ties specific default INI files to
*************************************************************************/
void UpdateDefINI(HWND hWnd)
{
 char cWork[250];
 HKEY keyH;
 DWORD dwValue;
 DWORD dwSize;
 LPSTR lps;

 //assume DefINI setting at LaunchFromCurrentMTS is correct...
 //DO NOT MODIFY!
 if (bNonStandardInstall) return;

 if (hWnd)
 {
  if (GetWindowText(hWnd,(LPSTR) cWork,29))
  {
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Soft"))
   {
    lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINNT\\MYTSOFT\\MYTSOFT.INI");
    //registry overwrite from hardcoded Default
    dwValue = REG_SZ;
    dwSize = sizeof(cWork);
 
    cWork[0] = 0;
    if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,WINPRODKEY,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
    {  
     if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
     {
      //See if value, then rework szDefIni
      if (lstrlen(cWork) > 0)
      {
       lps = lstrrchr(cWork,'\\');
       if (lps)
       {
        lps++;
        *lps = 0;
        lstrcat(cWork,"MYTSOFT.INI");
        lstrcpy(szDefINI,cWork);
       }
      }
     }
     RegCloseKey(keyH);
    }
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Touch"))
   {
    lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINDOWS\\MYTTOUCH\\MYTTOUCH.INI");
   }
   if (!lstrcmp((LPSTR) cWork,(LPSTR) "My-T-Pen"))
   {
    lstrcpy((LPSTR) szDefINI,(LPSTR)"C:\\WINDOWS\\MYTPEN\\MYTPEN.INI");
   }
  }  //GetWindowText has a string
 }
 else  //hWnd is NULL
 {
   //registry overwrite from hardcoded Default
  dwValue = REG_SZ;
  dwSize = sizeof(cWork);
  cWork[0] = 0;
  if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,WINPRODKEY,0,KEY_QUERY_VALUE,&keyH) == ERROR_SUCCESS) 
  {  
   if (RegQueryValueEx(keyH,"UninstallString",NULL,&dwValue,(LPBYTE) cWork,&dwSize) == ERROR_SUCCESS) 
   {
    //See if value, then rework szDefIni
    if (lstrlen(cWork) > 0)
    {
     lps = lstrrchr(cWork,'\\');
     if (lps)
     {
      lps++;
      *lps = 0;
      lstrcat(cWork,"MYTSOFT.INI");
      lstrcpy(szDefINI,cWork);
     }
    }
   }
   RegCloseKey(keyH);
  }  //reg open
 } //hWnd 
}
/*************************************************************************
* NoMyTSoft
*************************************************************************/
void NoMyTSoft(void)
{
 MessageBeep(MB_ICONEXCLAMATION);
 MessageBox(NULL,"For the full effect of this demonstration (and proper operation), My-T-Soft/My-T-Touch/My-T-Pen must be running! - See Launch Button upper right of VB Form...","My-T-Soft/My-T-Touch/My-T-Pen NOT FOUND!",MB_OK | MB_ICONEXCLAMATION);
}
/*************************************************************************
* END OF CODE
*************************************************************************/
